using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      int annot, reply;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               // To see the migration state, right click on the annotation and then on Review History.
               // You need Reader X or higher to see the result. Acrobat or Reader 9 use another state model that is no longer supported.
               annot = pdf.SquareAnnot(50.0, 50.0, 200.0, 100.0, 3.0, CPDF.NO_COLOR, 255, TPDFColorSpace.csDeviceRGB, "Jim", "Test", "Just test...");
               reply = pdf.SetAnnotMigrationState(annot, TAnnotState.asCompleted, "Harry");
               pdf.SetAnnotString(reply, TAnnotString.asContent, "The state was set to Completed!");

               reply = pdf.SetAnnotMigrationState(reply, TAnnotState.asAccepted, "Jim");
               pdf.SetAnnotString(reply, TAnnotString.asContent, "The state was set to Accepted!");
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process pcs = new System.Diagnostics.Process();
                  pcs.StartInfo.FileName = filePath;
                  pcs.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
